---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：93-Unsafe Operations

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **UnsafeMemoryAllocator/HeapMemoryAllocatorの詳細実装**: ファイル存在は確認済みだが詳細コードは未読

## 2) 参照した情報（Evidence一覧）

- E-01: `common/unsafe/src/main/java/org/apache/spark/unsafe/Platform.java`
- E-02: `common/unsafe/src/main/java/org/apache/spark/unsafe/memory/MemoryBlock.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | sun.misc.Unsafeのリフレクション取得 | E-01 (line 280-289) | ○ |
| C-02 | 各型配列のベースオフセット計算 | E-01 (line 291-307) | ○ |
| C-03 | getInt/putInt等のプリミティブアクセス | E-01 (line 119-173) | ○ |
| C-04 | allocateMemory/freeMemoryの委譲 | E-01 (line 183-189) | ○ |
| C-05 | reallocateMemoryの新確保→コピー→解放 | E-01 (line 191-196) | ○ |
| C-06 | copyMemoryのオーバーラップ対応 | E-01 (line 245: dstOffset < srcOffset判定) | ○ |
| C-07 | UNSAFE_COPY_THRESHOLD = 1MB | E-01 (line 278) | ○ |
| C-08 | allocateDirectBufferのCleaner分岐 | E-01 (line 201-231) | ○ |
| C-09 | Java 21以降のコンストラクタシグネチャ変更 | E-01 (line 64-66) | ○ |
| C-10 | CLEANER_CREATE_METHODの可用性チェック | E-01 (line 88-93) | ○ |
| C-11 | unaligned判定ロジック | E-01 (line 311-338) | ○ |
| C-12 | MemoryBlock.NO_PAGE_NUMBER = -1 | E-02 (line 30-31) | ○ |
| C-13 | MemoryBlock.FREED_IN_TMM_PAGE_NUMBER = -2 | E-02 (line 40) | ○ |
| C-14 | MemoryBlock.FREED_IN_ALLOCATOR_PAGE_NUMBER = -3 | E-02 (line 46) | ○ |
| C-15 | fromLongArray計算: array.length * 8L | E-02 (line 72-74) | ○ |
| C-16 | HeapMemoryAllocator/UnsafeMemoryAllocator詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: HeapMemoryAllocatorとUnsafeMemoryAllocatorの具体的な実装コードを直接読み込んでいない
  - 候補：HeapMemoryAllocator.java / UnsafeMemoryAllocator.java の詳細コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Platform.javaの主要処理はすべて行番号付きで確認済み
- 0: 低リスク - MemoryBlockの定数値はコードと完全一致
- 1: 中リスク - メモリアロケータの詳細実装は推論に基づく部分あり

## 6) レビュアーチェックリスト（最小）
- [ ] copyMemoryのオーバーラップ対応の前方/後方コピーロジックが正しいか確認
- [ ] Java 21対応のコンストラクタシグネチャ変更が正確か確認
- [ ] CLEANER_CREATE_METHODの利用不可時のフォールバック動作を確認
